/***************************************************************************
 *   Copyright (C) 2015 by Laboratoire d'Economie Forestière               *
 *   http://ffsm-project.org                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version, given the compliance with the     *
 *   exceptions listed in the file COPYING that is distribued together     *
 *   with this file.                                                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "time.h"

#include "Scheduler.h"
#include "ThreadManager.h"
#include "Output.h"
#include "ModelData.h"
#include "Gis.h"
#include "ModelCore.h"
#include "ModelCoreSpatial.h"

Scheduler::Scheduler(ThreadManager* MTHREAD_h){
  MTHREAD=MTHREAD_h;
  iteration=0;
}

Scheduler::~Scheduler(){
}

void
Scheduler::run(){

  int initialYear           = MTHREAD->MD->getIntSetting("initialYear");
  int initialSimulationYear = MTHREAD->MD->getIntSetting("initialOptYear");
  int preSimulationYears = initialSimulationYear-initialYear;
  for (int it=preSimulationYears;it<MTHREAD->MD->getIntSetting("simulationYears")+preSimulationYears;it++){
    iteration = it;
    year = iteration+MTHREAD->MD->getCachedInitialYear();
    MTHREAD->upgradeMainSBLabel("New year started..");
    msgOut(MSG_INFO, "### "+i2s(getYear())+ " year started.. ####");
    time_t now;
    time(&now);
    struct tm *current = localtime(&now);
    string timemessage = "("+i2s(current->tm_hour)+":"+i2s(current->tm_min)+":"+ i2s(current->tm_sec)+")";
    MTHREAD->upgradeYearSBLabel(iteration+ MTHREAD->MD->getIntSetting("initialYear"));
    MTHREAD->treeViewerChangeGeneralPropertyValue("year",i2s(iteration+ MTHREAD->MD->getIntSetting("initialYear")));
    if(MTHREAD->MD->getBoolSetting("usePixelData")){
      //MTHREAD->GIS->initLayersModelData(); // removed 20120930, not needed, as data in specific pixel values
      MTHREAD->SCORE->runSimulationYear();
    } else {
      MTHREAD->CORE->runSimulationYear();
    }


    //MTHREAD->DO->print(); // done within modelcore now

    for(int i=0;i<MTHREAD->GIS->getXNPixels();i++){
      MTHREAD->GIS->getPixel(i)->newYear(); //delete objects for the pixels, in the update the agents will do the same for their objects
    }
  }
}

